<?php
//receive_data.php

header('Content-Type: application/json');

$receivedToken = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$sharedSecretToken = '6b2049d42314d6c3dbc8a44cc23d61b9d5158455d0039123f4f0e033a7bc3733';

// Validasi token
if ($receivedToken !== 'Bearer ' . $sharedSecretToken) {
    http_response_code(401);
    echo json_encode(['message' => 'Token tidak valid. Akses ditolak.']);
    exit;
}

$jsonData = file_get_contents('php://input');
$data = json_decode($jsonData, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['message' => 'Gagal mengurai JSON: ' . json_last_error_msg()]);
    exit;
}

// Validasi kolom yang wajib diisi
$requiredFields = ['id', 'origin', 'date_done', 'creation_date', 'branch_name', 'schedule_date', 'customer_name', 'branch_id', 'name', 'state', 'customer_id', 'pack_operation_product_ids'];
$missingFields = array_filter($requiredFields, fn($field) => !isset($data[$field]));

if (!empty($missingFields)) {
    http_response_code(400);
    echo json_encode(['message' => 'Kolom berikut harus diisi: ' . implode(', ', $missingFields)]);
    exit;
}

// ---- LOGIKA UTAMA ----
include './config.php';

$is_edit = isset($data['is_edit']) && $data['is_edit'] === true;
$id_out = $data['id'];

// Memulai transaksi untuk menjaga integritas data
$conn->begin_transaction();

try {
    if ($is_edit) {
        // =================================================
        // LOGIKA UNTUK UPDATE DATA (is_edit = true)
        // =================================================

        // 1. Update tabel utama (outgoing_data)
        $stmt_update_main = $conn->prepare(
            "UPDATE outgoing_data SET 
                origin = ?, date_done = ?, creation_date = ?, branch_name = ?, 
                schedule_date = ?, customer_name = ?, branch_id = ?, name = ?, 
                note = ?, state = ?, customer_id = ?
            WHERE id = ?"
        );
        $stmt_update_main->bind_param(
            "ssssssisssii",
            $data['origin'], $data['date_done'], $data['creation_date'], $data['branch_name'], 
            $data['schedule_date'], $data['customer_name'], $data['branch_id'], $data['name'], 
            $data['note'], $data['state'], $data['customer_id'], $id_out
        );
        $stmt_update_main->execute();
        $stmt_update_main->close();

        // 2. Hapus item lama di tabel relasi
        $stmt_delete_items = $conn->prepare("DELETE FROM pack_operation_product WHERE picking_id = ?");
        $stmt_delete_items->bind_param("i", $id_out);
        $stmt_delete_items->execute();
        $stmt_delete_items->close();

        // 3. Masukkan kembali item baru (menggunakan logika yang sama dengan insert)
        foreach ($data['pack_operation_product_ids'] as $item) {
            insert_pack_operation($conn, $item, $id_out);
        }
        
        echo json_encode(['message' => "Data dengan ID $id_out berhasil diperbarui."]);

    } else {
        // =================================================
        // LOGIKA UNTUK INSERT DATA BARU (is_edit = false)
        // =================================================
        $checkStmt = $conn->prepare("SELECT id FROM outgoing_data WHERE id = ?");
        $checkStmt->bind_param("i", $id_out);
        $checkStmt->execute();
        $checkStmt->store_result();

        if ($checkStmt->num_rows > 0) {
            http_response_code(409); // 409 Conflict
            echo json_encode(['message' => "Data dengan ID $id_out sudah ada."]);
        } else {
            // 1. Insert ke tabel utama (outgoing_data)
            $stmt1 = $conn->prepare("INSERT INTO outgoing_data (id, origin, date_done, creation_date, branch_name, schedule_date, customer_name, branch_id, name, note, state, customer_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt1->bind_param(
                "issssssisssi", 
                $id_out, $data['origin'], $data['date_done'], $data['creation_date'], $data['branch_name'], 
                $data['schedule_date'], $data['customer_name'], $data['branch_id'], $data['name'], 
                $data['note'], $data['state'], $data['customer_id']
            );
            $stmt1->execute();
            $stmt1->close();
            
            // 2. Insert item-item ke tabel relasi
            foreach ($data['pack_operation_product_ids'] as $item) {
                insert_pack_operation($conn, $item, $id_out);
            }
            
            http_response_code(201); // 201 Created
            echo json_encode(['message' => "Data dengan ID $id_out berhasil disimpan."]);
        }
        $checkStmt->close();
    }

    // Jika semua query berhasil, simpan perubahan
    $conn->commit();

} catch (Exception $e) {
    // Jika ada error, batalkan semua perubahan
    $conn->rollback();
    http_response_code(500);
    echo json_encode(['message' => 'Terjadi kesalahan pada server: ' . $e->getMessage()]);
}

$conn->close();

/**
 * Fungsi untuk memasukkan data ke tabel pack_operation_product.
 * Dibuat menjadi fungsi agar bisa digunakan ulang untuk proses INSERT dan UPDATE.
 *
 * @param mysqli $conn Koneksi database
 * @param array $item Satu item dari pack_operation_product_ids
 * @param int $picking_id ID dari data utama (outgoing_data)
 */
function insert_pack_operation($conn, $item, $picking_id) {
    $stock_quant_id = null;
    $product_code = $item['product_code'] ?? null;
    $location_id = $item['location_id'] ?? null;

    // Cari stock_quant_id jika product_code dan location_id tersedia
    if ($product_code && $location_id) {
        $stock_quant_query = "SELECT id FROM product_stock_by_location WHERE product_code = ? AND location_id = ?";
        $stock_quant_stmt = $conn->prepare($stock_quant_query);
        $stock_quant_stmt->bind_param('si', $product_code, $location_id);
        $stock_quant_stmt->execute();
        $stock_quant_stmt->store_result();
        
        if ($stock_quant_stmt->num_rows > 0) {
            $stock_quant_stmt->bind_result($fetched_id);
            $stock_quant_stmt->fetch();
            $stock_quant_id = $fetched_id;
        }
        $stock_quant_stmt->close();
    }

    // Siapkan query
    $query = "INSERT INTO pack_operation_product 
                (id, description_picking, product_qty, location_id, quantity_done, location_name, 
                product_id, product_code, product_uom_id, location_dest_id, ordered_qty, 
                product_uom_name, product_name, picking_id, stock_quant_id) 
              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($query);

    // Tentukan tipe data untuk stock_quant_id
    $types = "isdidsisiidssii"; // Default: semua tidak NULL
    
    // Jika stock_quant_id NULL, ubah tipe binding terakhir menjadi 's'
    if ($stock_quant_id === null) {
        $types = "isdidsisiidssis";
    }

    $stmt->bind_param(
        $types,
        $item['id'],
        $item['description_picking'],
        $item['product_qty'],
        $item['location_id'],
        $item['quantity_done'],
        $item['location_name'],
        $item['product_id'],
        $item['product_code'],
        $item['product_uom_id'],
        $item['location_dest_id'],
        $item['ordered_qty'],
        $item['product_uom_name'],
        $item['product_name'],
        $picking_id,
        $stock_quant_id // Akan dikirim sebagai NULL jika tidak ditemukan
    );

    $stmt->execute();
    if ($stmt->error) {
        throw new Exception("Gagal memasukkan item: " . $stmt->error);
    }
    $stmt->close();
}
?>