<?php
// new_receive_data.php

header('Content-Type: application/json');

$receivedToken = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$sharedSecretToken = '6b2049d42314d6c3dbc8a44cc23d61b9d5158455d0039123f4f0e033a7bc3733';

// Validasi token
if ($receivedToken !== 'Bearer ' . $sharedSecretToken) {
    http_response_code(401);
    echo json_encode(['message' => 'Token tidak valid. Akses ditolak.']);
    exit;
}

$jsonData = file_get_contents('php://input');
$data = json_decode($jsonData, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['message' => 'Gagal mengurai JSON: ' . json_last_error_msg()]);
    exit;
}

// ---- LOGIKA UTAMA ----
include './config.php'; // Pastikan file ini menggunakan $conn

$is_edit = isset($data['is_edit']) && $data['is_edit'] === true;

// ## PERUBAHAN 1: Validasi dinamis
// DIHAPUS: branch_name, branch_id
$requiredFields = ['origin', 'date_done', 'creation_date', 'schedule_date', 'customer_name', 'name', 'state', 'customer_id', 'pack_operation_product_ids'];

$missingFields = array_filter($requiredFields, fn($field) => !isset($data[$field]));

if (!empty($missingFields)) {
    http_response_code(400);
    echo json_encode(['message' => 'Kolom berikut harus diisi: ' . implode(', ', $missingFields)]);
    exit;
}

// Memulai transaksi untuk menjaga integritas data
$conn->begin_transaction();

try {
    if ($is_edit) {
        // =================================================
        // ## PERUBAHAN 2: LOGIKA UPDATE DATA
        // =================================================

        $invoice_number = $data['name'];
        $id_out = null;

        // 2. Cari 'id' internal berdasarkan 'name'
        $stmt_find = $conn->prepare("SELECT id FROM outgoing_data WHERE name = ?");
        $stmt_find->bind_param("s", $invoice_number);
        $stmt_find->execute();
        $result = $stmt_find->get_result();

        if ($row = $result->fetch_assoc()) {
            $id_out = $row['id'];
        }
        $stmt_find->close();

        if ($id_out === null) {
            http_response_code(404);
            echo json_encode(['message' => "Data dengan nomor invoice '$invoice_number' tidak ditemukan."]);
            $conn->rollback();
            exit;
        }

        // 3. Update tabel utama (outgoing_data)
        // DIHAPUS: branch_name, branch_id
        $stmt_update_main = $conn->prepare(
            "UPDATE outgoing_data SET 
                origin = ?, date_done = ?, creation_date = ?, schedule_date = ?, 
                customer_name = ?, note = ?, state = ?, customer_id = ?
            WHERE name = ?" // 8 kolom SET + 1 kolom WHERE
        );
        // DIUBAH: Tipe data disesuaikan (8 + 1)
        $stmt_update_main->bind_param(
            "sssssssis", // 9 tipe data, 's' terakhir untuk 'name'
            $data['origin'], $data['date_done'], $data['creation_date'], 
            $data['schedule_date'], $data['customer_name'],
            $data['note'], $data['state'], $data['customer_id'],
            $invoice_number // Variabel untuk WHERE
        );
        $stmt_update_main->execute();
        $stmt_update_main->close();

        // 4. Hapus item lama
        $stmt_delete_items = $conn->prepare("DELETE FROM pack_operation_product WHERE picking_id = ?");
        $stmt_delete_items->bind_param("i", $id_out);
        $stmt_delete_items->execute();
        $stmt_delete_items->close();

        // 5. Masukkan kembali item-item baru
        foreach ($data['pack_operation_product_ids'] as $item) {
            insert_pack_operation($conn, $item, $id_out);
        }
        
        echo json_encode(['message' => "Data dengan nomor invoice '$invoice_number' berhasil diperbarui."]);

    } else {
        // =================================================
        // ## PERUBAHAN 3: LOGIKA INSERT DATA BARU
        // =================================================

        // Cek duplikasi berdasarkan 'name'
        $checkStmt = $conn->prepare("SELECT id FROM outgoing_data WHERE name = ?");
        $checkStmt->bind_param("s", $data['name']);
        $checkStmt->execute();
        $checkStmt->store_result();

        if ($checkStmt->num_rows > 0) {
            http_response_code(409);
            echo json_encode(['message' => "Data dengan nomor invoice '" . $data['name'] . "' sudah ada."]);
        } else {
            // 1. Insert ke tabel utama (outgoing_data)
            // DIHAPUS: branch_name, branch_id
            $stmt1 = $conn->prepare(
                "INSERT INTO outgoing_data (origin, date_done, creation_date, schedule_date, customer_name, name, note, state, customer_id) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)" // 9 kolom
            );
            // DIUBAH: Tipe data disesuaikan (9)
            $stmt1->bind_param(
                "sssssssis", // 9 tipe data
                $data['origin'], $data['date_done'], $data['creation_date'],
                $data['schedule_date'], $data['customer_name'], $data['name'], 
                $data['note'], $data['state'], $data['customer_id']
            );
            $stmt1->execute();

            $new_id_out = $conn->insert_id;
            $stmt1->close();
            
            // 2. Insert item-item ke tabel relasi
            foreach ($data['pack_operation_product_ids'] as $item) {
                insert_pack_operation($conn, $item, $new_id_out);
            }
            
            http_response_code(201);
            echo json_encode(['message' => "Data berhasil disimpan dengan ID baru: $new_id_out."]);
        }
        $checkStmt->close();
    }

    // Jika semua query berhasil, simpan perubahan
    $conn->commit();

} catch (Exception $e) {
    // Jika ada error, batalkan semua perubahan
    $conn->rollback();
    http_response_code(500);
    echo json_encode(['message' => 'Terjadi kesalahan pada server: ' . $e->getMessage()]);
}

$conn->close();


/**
 * Fungsi untuk memasukkan data ke tabel pack_operation_product.
 *
 * @param mysqli $conn Koneksi database
 * @param array $item Satu item dari pack_operation_product_ids
 * @param int $picking_id ID dari data utama (outgoing_data)
 */
function insert_pack_operation($conn, $item, $picking_id) {
    $stock_quant_id = null;
    $product_code = $item['product_code'] ?? null;
    // DIHAPUS: $location_id

    if ($product_code) {
        // DIUBAH: Query hanya mencari berdasarkan product_code
        $stock_quant_query = "SELECT id FROM product_stock_by_location WHERE product_code = ?";
        $stock_quant_stmt = $conn->prepare($stock_quant_query);
        $stock_quant_stmt->bind_param('s', $product_code);
        $stock_quant_stmt->execute();
        $stock_quant_stmt->store_result();
        
        if ($stock_quant_stmt->num_rows > 0) {
            $stock_quant_stmt->bind_result($fetched_id);
            $stock_quant_stmt->fetch();
            $stock_quant_id = $fetched_id;
        }
        $stock_quant_stmt->close();
    }

    // =========================================================================
    // === INI ADALAH PERBAIKAN FATAL ERROR ===
    // =========================================================================

    // DIHAPUS: kolom 'location_id' dan 'location_name'
    $query = "INSERT INTO pack_operation_product 
                (id, description_picking, product_qty, quantity_done, 
                product_id, product_code, product_uom_id, location_dest_id, ordered_qty, 
                product_uom_name, product_name, picking_id, stock_quant_id) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; // 13 tanda tanya (?)

    $stmt = $conn->prepare($query);

    // Membangun string 12 tipe data pertama
    // Var: id, description_picking, product_qty, quantity_done
    // Tipe: i, s, d, d
    // Var: product_id, product_code, product_uom_id, location_dest_id, ordered_qty
    // Tipe: i, s, i, i, d
    // Var: product_uom_name, product_name, picking_id
    // Tipe: s, s, i
    $types = "isddisiidssi"; // Ini 12 karakter

    // Tambahkan tipe data ke-13 (stock_quant_id)
    if ($stock_quant_id === null) {
        $types .= "s"; // Kirim NULL sebagai tipe 'string' (cara mysqli menangani NULL)
    } else {
        $types .= "i"; // Kirim ID sebagai 'integer'
    }
    // SEKARANG $types dijamin memiliki 13 karakter, SAMA DENGAN 13 variabel di bawah.

    $stmt->bind_param(
        $types, // String tipe data yang sudah diperbaiki (13 karakter)
        
        $item['id'],
        $item['description_picking'],
        $item['product_qty'],
        $item['quantity_done'],
        // DIHAPUS: $item['location_id'],
        // DIHAPUS: $item['location_name'],
        $item['product_id'],
        $item['product_code'],
        $item['product_uom_id'],
        $item['location_dest_id'],
        $item['ordered_qty'],
        $item['product_uom_name'],
        $item['product_name'],
        $picking_id,
        $stock_quant_id // Variabel ke-13
    );
    // =========================================================================
    // === AKHIR PERBAIKAN ===
    // =========================================================================

    $stmt->execute();
    if ($stmt->error) {
        throw new Exception("Gagal memasukkan item: " . $stmt->error);
    }
    $stmt->close();
}
?>